﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Newsletter
{
    public partial class Newsletters : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindNewsLettersList(string.Empty);
            }
        }

        private void BindNewsLettersList(string searchWord)
        {
            List<NewsLetters> pbList = NewsLettersBL.GetList(Guid.Empty, searchWord);
            pbList = (from pb in pbList
                      orderby pb.CreatedDate descending
                      select pb).ToList<NewsLetters>();
            grdNewsLetters.DataSource = pbList;
            grdNewsLetters.DataBind();

            if (pbList.Count == 0)
                WebUtilities.ShowMessage(this, "No News Letters found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindNewsLettersList(string.Empty);
            Master.ExportToExcel<Entities.NewsLetters>(grdNewsLetters, "Newsletters");
        }

        protected void grdNewsLetters_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdNewsLetters.PageIndex = e.NewPageIndex;
            BindNewsLettersList(txtSearch.Text.Trim());
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtSearch.Text.Trim().Length == 0)
            {
                WebUtilities.ShowMessage(this, "Please enter the search word");
                return;
            }
            BindNewsLettersList(txtSearch.Text.Trim());
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindNewsLettersList(string.Empty);
        }
    }
}